unit sdom;
{
/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is the Sablopas : Pascal wrapper for Sablotron.
 *
 * More infos at http://www.tekool.com/sablopas - Contact : cespern@free.fr
 *
 * The Initial Developer of the Original Code is Christophe ESPERN
 * Portions created by Christophe ESPERN are Copyright (C) 2001-2002 Christophe
 * ESPERN. All Rights Reserved.
 *
 * Contributor(s):
}

interface

uses
 sablot,shandler;

const
  SDOM_ELEMENT_NODE = 1;
  SDOM_ATTRIBUTE_NODE = 2;
  SDOM_TEXT_NODE = 3;
  SDOM_CDATA_SECTION_NODE = 4;
  SDOM_ENTITY_REFERENCE_NODE = 5;
  SDOM_ENTITY_NODE = 6;
  SDOM_PROCESSING_INSTRUCTION_NODE = 7;
  SDOM_COMMENT_NODE = 8;
  SDOM_DOCUMENT_NODE = 9;
  SDOM_DOCUMENT_TYPE_NODE = 10;
  SDOM_DOCUMENT_FRAGMENT_NODE = 11;
  SDOM_NOTATION_NODE = 12;
  SDOM_OTHER_NODE=0;

  SDOM_OK=0;
  SDOM_INDEX_SIZE_ERR = 1;
  SDOM_HIERARCHY = 3;
  SDOM_WRONG_DOCUMENT_ERR = 4;
  SDOM_NO_MODIFICATION_ALLOWED_ERR = 7;
  SDOM_NOT_FOUND_ERR = 8;

type
 // Pas de Dclaration de SDOMChar
// tous les paramtres const sont passs comme  string
// tous les paramtres var sont passs comme PChar


 SDomNodeType=type shortint;
 SDomException=type shortint;
 SDomLength=type shortint;
 SDomNodeList= type LongWord;
 SNodeCallBack = procedure(n:SDomNode);
 DomString=string;

 PDomNodeList= ^SDomNodeList;
 PDomNodeType=^SDomNodeType;
 PNodeCallBack=^SNodeCallBack;


 {************** DOM Fonctions -DOM Fonctions -DOM Fonctions - DOM Fonctions ************}

 // Document Operations
 function SDOM_createElement(s:SablotSituation;d:SDomDocument;pn:PDomNode;const tagName:domstring):SDomException; cdecl;external SAB_LIB;
 function SDOM_createAttribute(s:SablotSituation;d:SDomDocument;pn:PDomNode;const name:domstring):SDomException; cdecl;external SAB_LIB;
 function SDOM_createTextNode(s:SablotSituation;d:SDomDocument;pn:PDomNode;const data:domstring):SDomException; cdecl;external SAB_LIB;
 function SDOM_createCDATASection(s:SablotSituation;d:SDomDocument;pn:PDomNode;const data:domstring):SDomException; cdecl;external SAB_LIB;
 function SDOM_createComment(s:SablotSituation;d:SDomDocument;pn:PDomNode;const data:domstring):SDomException; cdecl;external SAB_LIB;
 function SDOM_createProcessingInstruction(s:SablotSituation;d:SDomDocument;pn:PDomNode;const target,data:domstring):SDomException; cdecl;external SAB_LIB;
 function SDOM_disposeNode(s:SablotSituation;n:SDomNode):SDomException;cdecl;external SAB_LIB;
 // Node Properties
 function SDOM_getNodeType(s:SablotSituation;n:SDomNode;var sType:sDomNodeType):SDomException;cdecl;external SAB_LIB;
 function SDOM_getNodeName(s:SablotSituation;n:SDomNode;pName:PChar):SDomException;cdecl;external SAB_LIB;
 function SDOM_setNodeName(s:SablotSituation;n:SDomNode;const name:domstring):SDomException;cdecl;external SAB_LIB;
 function SDOM_getNodeValue(s:SablotSituation;n:SDomNode;pValue:PChar):SDomException;cdecl;external SAB_LIB;
 function SDOM_setNodeValue(s:SablotSituation;n:SDomNode;const value:domstring):SDomException;cdecl;external SAB_LIB;
 function SDOM_getParentNode(s:SablotSituation;n:SDomNode;pParent:PDomNode):SDomException;cdecl;external SAB_LIB;
 function SDOM_getFirstChild(s:SablotSituation;n:SDomNode;pFirstChild:PDomNode):SDomException;cdecl;external SAB_LIB;
 function SDOM_getLastChild(s:SablotSituation;n:SDomNode;pLastChild:PDomNode):SDomException;cdecl;external SAB_LIB;
 function SDOM_getPreviousSibling(s:SablotSituation;n:SDomNode;pPreviousSibling:PDomNode):SDomException;cdecl;external SAB_LIB;
 function SDOM_getNextSibling(s:SablotSituation;n:SDomNode;pNextSibling:PDomNode):SDomException;cdecl;external SAB_LIB;
 function SDOM_getOwnerDocument(s:SablotSituation;n:SDomNode;pOwnerDocument:PDomDocument):SDomException; cdecl;external SAB_LIB;
 function SDOM_getChildNodeIndex(s:SablotSituation;n:SDOMNode;index:integer;pChildNode:PDOmNode):SDOMException;cdecl;external SAB_LIB;
 function SDOM_getChildNodeCount(s:SablotSituation;n:SDOMNode;var count:SDomLength):SDOMException;cdecl;external SAB_LIB;
 //NS functions
 function SDOM_getNodeNSUri(s:SablotSituation;n:SDomNode;pName:Pchar):SDomException;cdecl;external SAB_LIB;
 function SDOM_getNodePrefix(s:SablotSituation;n:SDomNode; pName:PChar):SDomException;cdecl;external SAB_LIB;
 function SDOM_getNodeLocalName(s:SablotSituation;n:SDomNode;pName:PChar):SDomException;cdecl;external SAB_LIB;
 function SDOM_createElementNS(s:SablotSituation;d:SDomDocument;pn:PDomNode;const uri,qname:domString):SDomException;cdecl;external SAB_LIB;
 function SDOM_createAttributeNS(s:SablotSituation;d:SDomDocument;pn:PDomNode;const uri,qname:domString):SDomException;cdecl;external SAB_LIB;
 function SDOM_getAttributeNS(s:SablotSituation;n:SdomNode;const uri,qname:domString;PValue:PChar):SDomException;cdecl;external SAB_LIB;
 function SDOM_getAttributeNodeNS(s:SablotSituation;n:SdomNode;const uri,qname:domString;PAttr:PDomNode):SDomException;cdecl;external SAB_LIB;
 function SDOM_setAttributeNS(s:SablotSituation;n:SdomNode;const uri,qname,value:domString):SDOMException;cdecl;external SAB_LIB;
 function SDOM_setAttributeNodeNS(s:SablotSituation;n:SDomNode;attnode:SDomNode;replaced:PDomNode):SDOMException;cdecl;external SAB_LIB;
 // Node Operations
 function SDOM_insertBefore(s:SablotSituation;n,newChild,refChild:SDomNode):SDomException; cdecl;external SAB_LIB;
 function SDOM_removeChild(s:SablotSituation;n,oldChild:SDomNode):SDomException; cdecl;external SAB_LIB;
 function SDOM_replaceChild(s:SablotSituation;n,newChild,oldChild:SDomNode):SDomException; cdecl;external SAB_LIB;
 function SDOM_appendChild(s:SablotSituation;n,newChild:SDomNode):SDomException; cdecl;external SAB_LIB;
 function SDOM_cloneNode(s:SablotSituation;n:SDomNode;deep:integer;clone:PDomNode):SDomException; cdecl;external SAB_LIB;
 function SDOM_cloneForeignNode(s:SablotSituation;d:SDomDocument;n:SDomNode;deep:integer;clone:PDomNode):SDomException; cdecl;external SAB_LIB;
 // Attribute
 function SDOM_getAttribute(s:SablotSituation;n:SDomNode;const Name:domstring;pValue:PChar):SDomException;cdecl;external SAB_LIB;
 function SDOM_setAttribute(s:SablotSituation;n:SDomNode;const Name:domstring;const value:domstring):SDomException;cdecl;external SAB_LIB;
 function SDOM_removeAttribute(s:SablotSituation;n:SDomNode;const Name:domstring):SDomException;cdecl;external SAB_LIB;
 function SDOM_getAttributeList(s:SablotSituation;n:SDomNode;pAttrList:PDomNodeList) :SDomException;cdecl;external SAB_LIB;
 function SDOM_getAttributeElement(s:SablotSituation;attr:SDOmNode;owner:PDomNode):SDomException;cdecl;external SAB_LIB;
 function SDOM_setAttributeNode(s:SablotSituation;n,attnode:SDOmNode;replaced:PDomNode):SDomException;cdecl;external SAB_LIB;
 function SDOM_removeAttributeNode(s:SablotSituation;n,attr:SDOmNode;removed:PDomNode):SDomException;cdecl;external SAB_LIB;
 // Fonctions Conversion DomTOString
 function SDOM_docToString(s:SablotSituation;d:SDomDocument;pSerialized:Pchar):SDomException; cdecl;external SAB_LIB;
 function SDOM_nodeToString(s:SablotSituation;d:SDomDocument;n:SDomNode;pSerialized:PChar):SDomException; cdecl;external SAB_LIB;
 // SDomNodeList
 function SDOM_getNodeListLength(s:SablotSituation;l:SDomNodeList;var length:SDomLength) :SDomException;cdecl;external SAB_LIB;
 function SDOM_getNodeListItem(s:SablotSituation;l:SDomNodeList;index:integer;pItem:PDomNode):SDomException;cdecl;external SAB_LIB;
 function SDOM_disposeNodeList(s:SablotSituation;l:SDomNodeList):SDomException;cdecl;external SAB_LIB;
 // XSQL
 function SDOM_xql(s:SablotSituation;const query:domstring;currentNode:SDomNode;pResult:PDomNodeList):SDomException;cdecl;external SAB_LIB;
 // Exception Retrieval
 function SDOM_getExceptionCode(s:SablotSituation):SDomException;cdecl;external SAB_LIB;
 function SDOM_getExceptionMessage(s:SablotSituation):PChar;cdecl;external SAB_LIB;
 function SDOM_getExceptionDetails(s:SablotSituation;code:SDomException;var msg,documentURI:PChar;fileline:integer):SDomException;cdecl;external SAB_LIB;
 //Internal Functions
 procedure SDOM_setNodeInstanceData(n:SDomNode;data:Pointer);cdecl;external SAB_LIB;
 function SDOM_getNodeInstanceData(n:SDomNode):Pointer;cdecl;external SAB_LIB;
 procedure SDOM_setDisposeCallback(f:PNodeCallBack);cdecl;external SAB_LIB;
 function SDOM_getDisposeCallback:PNodeCallBack;cdecl;external SAB_LIB;



implementation

end.
